<?php
/*======================================================================*\
|| 	  EDIT BY MGHOOL chat3hood@hotmail.com & iiio__oiii@hotmail.com     ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: user.php,v $ - $Revision: 1.370 $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cpuser', 'forum', 'timezone', 'user', 'cprofilefield', 'subscription');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_profilefield.php');
require_once(DIR . '/includes/adminfunctions_user.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
$vbulletin->input->clean_array_gpc('r', array(
	'userid' => TYPE_INT
));
log_admin_action(iif($vbulletin->GPC['userid'] != 0, 'user id = ' . $vbulletin->GPC['userid']));

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['user_manager']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'add';
}

// ###################### Start email password #######################
if ($_REQUEST['do'] == 'emailpassword')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'email' => TYPE_STR
	));

	print_form_header('../login', 'emailpassword');
	construct_hidden_code('email', $vbulletin->GPC['email']);
	construct_hidden_code('url', $vbulletin->config['Misc']['admincpdir'] . "/user.php?do=find&user[email]=" . urlencode($vbulletin->GPC['email']));
	print_table_header($vbphrase['email_password_reminder_to_user']);
	print_description_row(construct_phrase($vbphrase['click_the_button_to_send_password_reminder_to_x'], "<i>" . htmlspecialchars_uni($vbulletin->GPC['email']) . "</i>"));
	print_submit_row($vbphrase['send'], 0);
}


// ###################### Start edit #######################
if ($_REQUEST['do'] == 'add')
{
	$OUTERTABLEWIDTH = '95%';
	$INNERTABLEWIDTH = '100%';

	// must include this in order to use bitwise()
	require_once(DIR . '/includes/functions_misc.php');

	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_UINT
	));

	if ($vbulletin->GPC['userid'])
	{

		$user = $db->query_first("
			SELECT user.*, avatar.avatarpath, customavatar.dateline AS avatardateline, customavatar.width AS avatarwidth, customavatar.height AS avatarheight,
			NOT ISNULL(customavatar.userid) AS hascustomavatar, usertextfield.signature,
			customprofilepic.width AS profilepicwidth, customprofilepic.height AS profilepicheight,
			customprofilepic.dateline AS profilepicdateline, usergroup.adminpermissions,
			NOT ISNULL(customprofilepic.userid) AS hasprofilepic,
			NOT ISNULL(sigpic.userid) AS hassigpic,
			sigpic.width AS sigpicwidth, sigpic.height AS sigpicheight,
			sigpic.userid AS profilepic, sigpic.dateline AS sigpicdateline
			FROM " . TABLE_PREFIX . "user AS user
			LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid)
			LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "customprofilepic AS customprofilepic ON(customprofilepic.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "sigpic AS sigpic ON(sigpic.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON(usertextfield.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "usergroup AS usergroup ON(usergroup.usergroupid = user.usergroupid)
			WHERE user.userid = " . $vbulletin->GPC['userid']
		);

		$user = array_merge($user, convert_bits_to_array($user['options'], $vbulletin->bf_misc_useroptions));
		$user = array_merge($user, convert_bits_to_array($user['adminoptions'], $vbulletin->bf_misc_adminoptions));

		if ($user['coppauser'] == 1)
		{
			echo "<p align=\"center\"><b>$vbphrase[this_is_a_coppa_user_do_not_change_to_registered]</b></p>\n";
		}

		if ($user['usergroupid'] == 3)
		{
			print_form_header('../register', 'emailcode', 0, 0);
			construct_hidden_code('email', $user['email']);
			print_submit_row($vbphrase['email_activation_codes'], 0);
		}

		// make array for quick links menu
		$quicklinks = array(
			"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=editaccess&u=" . $vbulletin->GPC['userid']
				=> $vbphrase['edit_forum_permissions_access_masks'],
			"resources.php?" . $vbulletin->session->vars['sessionurl'] . "do=viewuser&u=" . $vbulletin->GPC['userid']
				=> $vbphrase['view_forum_permissions'],
			"mailto:$user[email]"
				=> $vbphrase['send_email_to_user']
		);

		if ($user['usergroupid'] == 3)
		{
			$quicklinks[
				"../register.php?" . $vbulletin->session->vars['sessionurl'] . "do=requestemail&email=" . urlencode(unhtmlspecialchars($user['email'])) . '&amp;url=' . urlencode($vbulletin->options['bburl'] . '/' . $vbulletin->config['Misc']['admincpdir'] . '/user.php?do=edit&u=' . $vbulletin->GPC['userid'])
			] = $vbphrase['email_activation_codes'];
		}

		require_once(DIR . '/includes/class_paid_subscription.php');
		$subobj = new vB_PaidSubscription($vbulletin);
		$subobj->cache_user_subscriptions();
		if (!empty($subobj->subscriptioncache))
		{
			$quicklinks[
				"subscriptions.php?" . $vbulletin->session->vars['sessionurl'] . "do=adjust&amp;userid=" . $vbulletin->GPC['userid']
			] = $vbphrase['add_paid_subscription'];
		}


		$quicklinks = array_merge(
			$quicklinks,
			array(
			"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=emailpassword&amp;email=" . urlencode(unhtmlspecialchars($user['email']))
				=> $vbphrase['email_password_reminder_to_user'],
			"../private.php?" . $vbulletin->session->vars['sessionurl'] . "do=newpm&amp;u=" . $vbulletin->GPC['userid']
				=> $vbphrase['send_private_message_to_user'],
			"usertools.php?" . $vbulletin->session->vars['sessionurl'] . "do=pmfolderstats&amp;u=" . $vbulletin->GPC['userid']
				=> $vbphrase['private_message_statistics'],
			"usertools.php?" . $vbulletin->session->vars['sessionurl'] . "do=removepms&amp;u=" . $vbulletin->GPC['userid']
				=> $vbphrase['delete_all_users_private_messages'],
			"usertools.php?" . $vbulletin->session->vars['sessionurl'] . "do=removesentpms&amp;u=" . $vbulletin->GPC['userid']
				=> $vbphrase['delete_private_messages_sent_by_user'],
			"usertools.php?" . $vbulletin->session->vars['sessionurl'] . "do=removesubs&amp;u=" . $vbulletin->GPC['userid']
				=> $vbphrase['delete_subscriptions'],
			"usertools.php?" . $vbulletin->session->vars['sessionurl'] . "do=doips&amp;u=" . $vbulletin->GPC['userid'] . "&amp;hash=" . CP_SESSIONHASH
				=> $vbphrase['view_ip_addresses'],
			"../member.php?" . $vbulletin->session->vars['sessionurl'] . "do=getinfo&amp;u=" . $vbulletin->GPC['userid']
				=> $vbphrase['view_profile'],
			"../search.php?" . $vbulletin->session->vars['sessionurl'] . "do=finduser&amp;u=" . $vbulletin->GPC['userid']
				=> $vbphrase['find_posts_by_user'],
			"admininfraction.php?" . $vbulletin->session->vars['sessionurl'] . "do=dolist&amp;startstamp=1&amp;endstamp= " . TIMENOW . "&amp;infractionlevelid=-1&amp;u= " . $vbulletin->GPC['userid']
				=> $vbphrase['view_infractions'],
			'../' . $vbulletin->config['Misc']['modcpdir'] . '/banning.php?' . $vbulletin->session->vars['sessionurl'] . "do=banuser&amp;u=" . $vbulletin->GPC['userid']
				=> $vbphrase['ban_user'],
			"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=remove&u=" . $vbulletin->GPC['userid']
				=> $vbphrase['delete_user'],
			)
		);

		if (intval($user['adminpermissions']) & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'] AND in_array($vbulletin->userinfo['userid'], preg_split('#\s*,\s*#s', $vbulletin->config['SpecialUsers']['superadministrators'], -1, PREG_SPLIT_NO_EMPTY)))
		{
			$quicklinks["adminpermissions.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&u=" . $vbulletin->GPC['userid']] = $vbphrase['edit_administrator_permissions'];
		}

		$userfield = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "userfield WHERE userid =" .  $vbulletin->GPC['userid']);

	}
	else
	{
		$regoption = array();
		if (bitwise($vbulletin->bf_misc_regoptions['subscribe_none'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['autosubscribe'] = -1;
		}
		else if (bitwise($vbulletin->bf_misc_regoptions['subscribe_nonotify'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['autosubscribe'] = 0;
		}
		else if (bitwise($vbulletin->bf_misc_regoptions['subscribe_instant'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['autosubscribe'] = 1;
		}
		else if (bitwise($vbulletin->bf_misc_regoptions['subscribe_daily'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['autosubscribe'] = 2;
		}
		else
		{
			$regoption['autosubscribe'] = 3;
		}

		if (bitwise($vbulletin->bf_misc_regoptions['vbcode_none'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['showvbcode'] = 0;
		}
		else if (bitwise($vbulletin->bf_misc_regoptions['vbcode_standard'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['showvbcode'] = 1;
		}
		else
		{
			$regoption['showvbcode'] = 2;
		}

		if (bitwise($vbulletin->bf_misc_regoptions['thread_linear_oldest'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['threadedmode'] = 0;
			$regoption['postorder'] = 0;
		}
		else if (bitwise($vbulletin->bf_misc_regoptions['thread_linear_newest'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['threadedmode'] = 0;
			$regoption['postorder'] = 1;
		}
		else if (bitwise($vbulletin->bf_misc_regoptions['thread_threaded'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['threadedmode'] = 1;
			$regoption['postorder'] = 0;
		}
		else if (bitwise($vbulletin->bf_misc_regoptions['thread_hybrid'], $vbulletin->options['defaultregoptions']))
		{
			$regoption['threadedmode'] = 2;
			$regoption['postorder'] = 0;
		}
		else
		{
			$regoption['threadedmode'] = 0;
			$regoption['postorder'] = 0;
		}

		$userfield = '';
		$user = array(
			'invisible'        => bitwise($vbulletin->bf_misc_regoptions['invisiblemode'], $vbulletin->options['defaultregoptions']) ? 1 : 0,
			'daysprune'        => -1,
			'joindate'         => TIMENOW,
			'lastactivity'     => TIMENOW,
			'lastpost'         => 0,
			'adminemail'       => iif(bitwise($vbulletin->bf_misc_regoptions['adminemail'], $vbulletin->options['defaultregoptions']), 1, 0),
			'showemail'        => iif(bitwise($vbulletin->bf_misc_regoptions['receiveemail'], $vbulletin->options['defaultregoptions']), 1, 0),
			'receivepm'        => iif(bitwise($vbulletin->bf_misc_regoptions['enablepm'], $vbulletin->options['defaultregoptions']), 1, 0),
			'receivepmbuddies' => 0,
			'emailonpm'        => iif(bitwise($vbulletin->bf_misc_regoptions['emailonpm'], $vbulletin->options['defaultregoptions']), 1, 0),
			'pmpopup'          => iif(bitwise($vbulletin->bf_misc_regoptions['pmpopup'], $vbulletin->options['defaultregoptions']), 1, 0),
			'showvcard'        => iif(bitwise($vbulletin->bf_misc_regoptions['vcard'], $vbulletin->options['defaultregoptions']), 1, 0),
			'autosubscribe'    => $regoption['autosubscribe'],
			'showreputation'   => iif(bitwise($vbulletin->bf_misc_regoptions['showreputation'], $vbulletin->options['defaultregoptions']), 1, 0),
			'reputation'       => $vbulletin->options['reputationdefault'],
			'showsignatures'   => iif(bitwise($vbulletin->bf_misc_regoptions['signature'], $vbulletin->options['defaultregoptions']), 1, 0),
			'showavatars'      => iif(bitwise($vbulletin->bf_misc_regoptions['avatar'], $vbulletin->options['defaultregoptions']), 1, 0),
			'showimages'       => iif(bitwise($vbulletin->bf_misc_regoptions['image'], $vbulletin->options['defaultregoptions']), 1, 0),
			'postorder'        => $regoption['postorder'],
			'threadedmode'     => $regoption['threadedmode'],
			'showvbcode'       => $regoption['showvbcode'],
			'usergroupid'      => 2,
			'dstauto'          => 1
		);
	}

	// get threaded mode options
	if ($user['threadedmode'] == 1 OR $user['threadedmode'] == 2)
	{
		$threaddisplaymode = $user['threadedmode'];
	}
	else
	{
		if ($user['postorder'] == 0)
		{
			$threaddisplaymode = 0;
		}
		else
		{
			$threaddisplaymode = 3;
		}
	}

	// make array for daysprune menu
	$pruneoptions = array(
		'0'   => '- ' . $vbphrase['use_forum_default'] . ' -',
		'1'   => $vbphrase['show_threads_from_last_day'],
		'2'   => construct_phrase($vbphrase['show_threads_from_last_x_days'], 2),
		'7'   => $vbphrase['show_threads_from_last_week'],
		'10'  => construct_phrase($vbphrase['show_threads_from_last_x_days'], 10),
		'14'  => construct_phrase($vbphrase['show_threads_from_last_x_weeks'], 2),
		'30'  => $vbphrase['show_threads_from_last_month'],
		'45'  => construct_phrase($vbphrase['show_threads_from_last_x_days'], 45),
		'60'  => construct_phrase($vbphrase['show_threads_from_last_x_months'], 2),
		'75'  => construct_phrase($vbphrase['show_threads_from_last_x_days'], 75),
		'100' => construct_phrase($vbphrase['show_threads_from_last_x_days'], 100),
		'365' => $vbphrase['show_threads_from_last_year'],
		'-1'  => $vbphrase['show_all_threads']
	);
	if ($pruneoptions["$user[daysprune]"] == '')
	{
		$pruneoptions["$user[daysprune]"] = construct_phrase($vbphrase['show_threads_from_last_x_days'], $user['daysprune']);
	}

	($hook = vBulletinHook::fetch_hook('useradmin_edit_start')) ? eval($hook) : false;

	// start main table
	print_form_header('user', 'update', 0, 0);
	?>
	<!--------------------------- BY MGHOOL --------------------------->
	<center>
	<a target="_blank" href="http://www.3hood.org" style="text-decoration: none">[      :  .. <font color="#FF0000"> </a></font> ]
	<br><br></center>
	<center>
	<a target="_blank" href="http://www.m3skrna.com/vb" style="text-decoration: none">[  : <font color="#FF0000"></a></font> ]
	<br><br></center>
	<!--------------------------- BY MGHOOL --------------------------->
	<table cellpadding="0" cellspacing="0" border="0" width="<?php echo $OUTERTABLEWIDTH; ?>" align="center"><tr valign="top"><td>
	<table cellpadding="4" cellspacing="0" border="0" align="center" width="100%" class="tborder">
	<?php

	construct_hidden_code('userid', $vbulletin->GPC['userid']);
	construct_hidden_code('ousergroupid', $user['usergroupid']);
	construct_hidden_code('odisplaygroupid', $user['displaygroupid']);

	if ($vbulletin->GPC['userid'])
	{
		// QUICK LINKS SECTION
		print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['user'], $user['username'], $vbulletin->GPC['userid']));
		print_label_row($vbphrase['quick_user_links'], '<select name="quicklinks" onchange="window.location=this.options[this.selectedIndex].value;" tabindex="1" class="bginput">' . construct_select_options($quicklinks) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="window.location=this.form.quicklinks.options[this.form.quicklinks.selectedIndex].value;" tabindex="2" />');
		print_table_break('', $INNERTABLEWIDTH);
	}

	// PROFILE SECTION
	print_table_header($vbphrase['profile']);
	/* *********************** BY MGHOOL *********************** */
	print_input_row($vbphrase['userid'], 'user[userid]', $user['userid'], 0);
	/* *********************** BY MGHOOL *********************** */
	print_input_row($vbphrase['username'], 'user[username]', " ");
	print_input_row($vbphrase['password'], 'password', "123456");
	print_input_row($vbphrase['email'], 'user[email]', "  ");
	print_select_row($vbphrase['language'] , 'user[languageid]', array('0' => $vbphrase['use_forum_default']) + fetch_language_titles_array('', 0), $user['languageid']);
	print_input_row($vbphrase['user_title'], 'user[usertitle]', $user['usertitle']);
	print_select_row($vbphrase['custom_user_title'], 'user[customtitle]', array(0 => $vbphrase['no'], 2 => $vbphrase['user_set'], 1 => $vbphrase['admin_set_html_allowed']), $user['customtitle']);
	print_input_row($vbphrase['personal_home_page'], 'user[homepage]', "http://www.m3skrna.com/vb", 0);
	print_time_row($vbphrase['birthday'], 'user[birthday]', $user['birthday'], 0, 1);
	print_select_row($vbphrase['privacy'], 'user[showbirthday]', array(0 => $vbphrase['hide_age_and_dob'], 1 => $vbphrase['display_age'], 2 => $vbphrase['display_age_and_dob']), $user['showbirthday']);
	print_textarea_row($vbphrase['signature'], 'user[signature]', $user['signature'], 8, 45);
	print_input_row($vbphrase['icq_uin'], 'user[icq]', $user['icq'], 0);
	print_input_row($vbphrase['aim_screen_name'], 'user[aim]', $user['aim'], 0);
	print_input_row($vbphrase['yahoo_id'], 'user[yahoo]', $user['yahoo'], 0);
	print_input_row($vbphrase['msn_id'], 'user[msn]', $user['msn'], 0);
	print_input_row($vbphrase['skype_name'], 'user[skype]', $user['skype'], 0);
	print_yes_no_row($vbphrase['coppa_user'], 'options[coppauser]', $user['coppauser']);
	print_input_row($vbphrase['parent_email_address'], 'user[parentemail]', $user['parentemail'], 0);
	if ($user['referrerid'])
	{
		$referrername = $db->query_first("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = $user[referrerid]");
		$user['referrer'] = $referrername['username'];
	}
	print_input_row($vbphrase['referrer'], 'user[referrerid]', $user['referrer'], 0);
	print_input_row($vbphrase['ip_address'], 'user[ipaddress]', $user['ipaddress']);
	print_input_row($vbphrase['post_count'], 'user[posts]', $user['posts'], 0, 7);
	print_table_break('', $INNERTABLEWIDTH);

	// USER IMAGE SECTION
	print_table_header($vbphrase['image_options']);
	if ($user['avatarid'])
	{
		$avatarurl = iif(substr($user['avatarpath'], 0, 7) != 'http://' AND substr($user['avatarpath'], 0, 1) != '/', '../') . $user['avatarpath'];
	}
	else
	{
		if ($user['hascustomavatar'])
		{
			if ($vbulletin->options['usefileavatar'])
			{
				$avatarurl = iif(substr($vbulletin->options['avatarurl'] , 0, 7) == 'http://', '', '../') . $vbulletin->options['avatarurl'] . "/avatar$user[userid]_$user[avatarrevision].gif";
			}
			else
			{
				$avatarurl = "../image.php?" . $vbulletin->session->vars['sessionurl'] . "u=$user[userid]&amp;dateline=$user[avatardateline]";
			}
			if ($user['avatarwidth'] AND $user['avatarheight'])
			{
				$avatarurl .= "\" width=\"$user[avatarwidth]\" height=\"$user[avatarheight]";
			}
		}
		else
		{
			$avatarurl = '../' . $vbulletin->options['cleargifurl'];
		}
	}
	if ($user['hasprofilepic'])
	{
		if ($vbulletin->options['usefileavatar'])
		{
			$profilepicurl = iif(substr($vbulletin->options['profilepicurl'] , 0, 7) == 'http://', '', '../') . $vbulletin->options['profilepicurl'] . "/profilepic$user[userid]_$user[profilepicrevision].gif";
		}
		else
		{
			$profilepicurl = "../image.php?" . $vbulletin->session->vars['sessionurl'] . "u=$user[userid]&amp;type=profile&amp;dateline=$user[profilepicdateline]";
		}

		if ($user['profilepicwidth'] AND $user['profilepicheight'])
		{
			$profilepicurl .= "\" width=\"$user[profilepicwidth]\" height=\"$user[profilepicheight]";
		}
	}
	else
	{
		$profilepicurl = '../' . $vbulletin->options['cleargifurl'];
	}
	if ($user['hassigpic'])
	{
		if ($vbulletin->options['usefileavatar'])
		{
			$sigpicurl = iif(substr($vbulletin->options['sigpicurl'] , 0, 7) == 'http://', '', '../') . $vbulletin->options['sigpicurl'] . "/sigpic$user[userid]_$user[sigpicrevision].gif";
		}
		else
		{
			$sigpicurl = "../image.php?" . $vbulletin->session->vars['sessionurl'] . "u=$user[userid]&amp;type=sigpic&amp;dateline=$user[sigpicdateline]";
		}

		if ($user['sigpicwidth'] AND $user['sigpicheight'])
		{
			$sigpicurl .= "\" width=\"$user[sigpicwidth]\" height=\"$user[sigpicheight]";
		}
	}
	else
	{
		$sigpicurl = '../' . $vbulletin->options['cleargifurl'];
	}

	print_label_row($vbphrase['avatar'] . '<input type="image" src="../' . $vbulletin->options['cleargifurl'] . '" alt="" />', '<img src="' . $avatarurl . '" alt="" align="top" /> &nbsp; <input type="submit" class="button" tabindex="1" name="modifyavatar" value="' . $vbphrase['change_avatar'] . '" />');
	print_label_row($vbphrase['profile_picture'] . '<input type="image" src="../' . $vbulletin->options['cleargifurl'] . '" alt="" />', '<img src="' . $profilepicurl . '" alt="" align="top" /> &nbsp; <input type="submit" class="button" tabindex="1" name="modifyprofilepic" value="' . $vbphrase['change_profile_picture'] . '" />');
	print_label_row($vbphrase['signature_picture'] . '<input type="image" src="../' . $vbulletin->options['cleargifurl'] . '" alt="" />', '<img src="' . $sigpicurl . '" alt="" align="top" /> &nbsp; <input type="submit" class="button" tabindex="1" name="modifysigpic" value="' . $vbphrase['change_signature_picture'] . '" />');
	print_table_break('', $INNERTABLEWIDTH);

	// PROFILE FIELDS SECTION
	print_table_header($vbphrase['user_profile_fields']);
	$profilefields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "profilefield ORDER by displayorder");
	while ($profilefield = $db->fetch_array($profilefields))
	{
		print_profilefield_row('userfield', $profilefield, $userfield);
		construct_hidden_code('userfield[field' . $profilefield['profilefieldid'] . '_set]', 1);
	}

	($hook = vBulletinHook::fetch_hook('useradmin_edit_column1')) ? eval($hook) : false;

	if ($vbulletin->options['cp_usereditcolumns'] == 2)
	{
		?>
		</table>
		</td><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td>
		<table cellpadding="4" cellspacing="0" border="0" align="center" width="100%" class="tborder">
		<?php
	}
	else
	{
		print_table_break('', $INNERTABLEWIDTH);
	}

	// USERGROUP SECTION
	print_table_header($vbphrase['usergroup_options']);
	print_chooser_row($vbphrase['primary_usergroup'], 'user[usergroupid]', 'usergroup', $user['usergroupid']);
	if (!empty($user['membergroupids']))
	{
		$usergroupids = $user['usergroupid'] . (!empty($user['membergroupids']) ? ',' . $user['membergroupids'] : '');
		print_chooser_row($vbphrase['display_usergroup'], 'user[displaygroupid]', 'usergroup', iif($user['displaygroupid'] == 0, -1, $user['displaygroupid']), $vbphrase['default'], 0, "WHERE usergroupid IN ($usergroupids)");
	}
	$tempgroup = $user['usergroupid'];
	$user['usergroupid'] = 0;
	print_membergroup_row($vbphrase['additional_usergroups'], 'user[membergroupids]', 0, $user);
	print_table_break('', $INNERTABLEWIDTH);
	$user['usergroupid'] = $tempgroup;

	if (!empty($subobj->subscriptioncache))
	{
		$subscribed = array();
		// fetch all active subscriptions the user is subscribed too
		$subs = $db->query_read("
			SELECT status, regdate, expirydate, subscriptionlogid, subscription.subscriptionid
			FROM " . TABLE_PREFIX . "subscriptionlog AS subscriptionlog
			INNER JOIN " . TABLE_PREFIX . "subscription AS subscription USING (subscriptionid)
			WHERE userid = " . $user['userid'] . "
			ORDER BY status DESC, regdate
			"
		);
		if ($db->num_rows($subs))
		{
			print_table_header($vbphrase['paid_subscriptions']);
			while ($sub = $db->fetch_array($subs))
			{
				$desc = "<div style=\"float:$stylevar[right]\"><input type=\"submit\" class=\"button\" tabindex=\"1\" name=\"subscriptionlogid[$sub[subscriptionlogid]]\" value=\"" . $vbphrase['edit'] . "\" />&nbsp;</div>";

				$joindate = vbdate($vbulletin->options['dateformat'], $sub['regdate'], false);
				$enddate = vbdate($vbulletin->options['dateformat'], $sub['expirydate'], false);
				if ($sub['status'])
				{
					$title = '<strong>' . $vbphrase['sub' . $sub['subscriptionid'] . '_title'] . '</strong>';
					$desc .= '<strong>' . construct_phrase($vbphrase['x_to_y'], $joindate, $enddate) . '</strong>';
				}
				else
				{
					$title = $vbphrase['sub' . $sub['subscriptionid'] . '_title'];
					$desc .= construct_phrase($vbphrase['x_to_y'], $joindate, $enddate);
				}

				print_label_row($title, $desc);
			}
			print_table_break('',$INNERTABLEWIDTH);
		}
	}

	// reputation SECTION
	require_once(DIR . '/includes/functions_reputation.php');

	if ($user['userid'])
	{
		$perms = fetch_permissions(0, $user['userid'], $user);
	}
	else
	{
		$perms = array();
	}
	$score = fetch_reppower($user, $perms);

	print_table_header($vbphrase['reputation']);
	print_yes_no_row($vbphrase['display_reputation'], 'options[showreputation]', $user['showreputation']);
	print_input_row($vbphrase['reputation_level'], 'user[reputation]', $user['reputation']);
	print_label_row($vbphrase['current_reputation_power'], $score, '', 'top', 'reputationpower');
	print_table_break('',$INNERTABLEWIDTH);

	print_table_header($vbphrase['infractions'] . construct_link_code($vbphrase['view'], "admininfraction.php?" . $vbulletin->session->vars['sessionurl'] . "do=dolist&amp;startstamp=1&amp;endstamp= " . TIMENOW . "&amp;infractionlevelid=-1&amp;u= " . $vbulletin->GPC['userid']));
	print_input_row($vbphrase['warnings'], 'user[warnings]', $user['warnings'], true, 5);
	print_input_row($vbphrase['infractions'], 'user[infractions]', $user['infractions'], true, 5);
	print_input_row($vbphrase['infraction_points'], 'user[ipoints]', $user['ipoints'], true, 5);
	if (!empty($user['infractiongroupids']))
	{
		$infractiongroups = explode(',', $user['infractiongroupids']);
		$groups = array();
		foreach($infractiongroups AS $groupid)
		{
			if (!empty($vbulletin->usergroupcache["$groupid"]['title']))
			{
				$groups[] = $vbulletin->usergroupcache["$groupid"]['title'];
			}
		}
		if (!empty($groups))
		{
			print_label_row($vbphrase['infraction_groups'], implode('<br />', $groups));
		}
		if (!empty($user['infractiongroupid']) AND $usertitle = $vbulletin->usergroupcache["$user[infractiongroupid]"]['usertitle'])
		{
			print_label_row($vbphrase['display_group'], 	$usertitle);
		}
	}
	print_table_break('',$INNERTABLEWIDTH);

	// BROWSING OPTIONS SECTION
	print_table_header($vbphrase['browsing_options']);
	print_yes_no_row($vbphrase['receive_admin_emails'], 'options[adminemail]', $user['adminemail']);
	print_yes_no_row($vbphrase['receive_user_emails'], 'options[showemail]', 1);
	print_yes_no_row($vbphrase['invisible_mode'], 'options[invisible]', $user['invisible']);
	print_yes_no_row($vbphrase['allow_vcard_download'], 'options[showvcard]', $user['showvcard']);
	print_yes_no_row($vbphrase['receive_private_messages'], 'options[receivepm]', $user['receivepm']);
	print_yes_no_row($vbphrase['pm_from_buddies_only'], 'options[receivepmbuddies]', $user['receivepmbuddies']);
	print_yes_no_row($vbphrase['send_notification_email_when_a_private_message_is_received'], 'options[emailonpm]', $user['emailonpm']);
	print_yes_no_row($vbphrase['pop_up_notification_box_when_a_private_message_is_received'], 'user[pmpopup]', $user['pmpopup']);
	print_yes_no_row($vbphrase['display_signatures'], 'options[showsignatures]', $user['showsignatures']);
	print_yes_no_row($vbphrase['display_avatars'], 'options[showavatars]', $user['showavatars']);
	print_yes_no_row($vbphrase['display_images'], 'options[showimages]', $user['showimages']);
	print_radio_row($vbphrase['auto_subscription_mode'], 'user[autosubscribe]', array(
		-1 => $vbphrase['subscribe_choice_none'],
		0  => $vbphrase['subscribe_choice_0'],
		1  => $vbphrase['subscribe_choice_1'],
		2  => $vbphrase['subscribe_choice_2'],
		3  => $vbphrase['subscribe_choice_3'],
	), $user['autosubscribe'], 'smallfont');


	print_radio_row($vbphrase['thread_display_mode'], 'user[threadedmode]', array(
		0 => "$vbphrase[linear] - $vbphrase[oldest_first]",
		3 => "$vbphrase[linear] - $vbphrase[newest_first]",
		2 => $vbphrase['hybrid'],
		1 => $vbphrase['threaded']
	), $threaddisplaymode, 'smallfont');

	print_radio_row($vbphrase['message_editor_interface'], 'user[showvbcode]', array(
		0 => $vbphrase['do_not_show_editor_toolbar'],
		1 => $vbphrase['show_standard_editor_toolbar'],
		2 => $vbphrase['show_enhanced_editor_toolbar']
	), $user['showvbcode'], 'smallfont');

	construct_style_chooser($vbphrase['style'], 'user[styleid]', $user['styleid']);
	print_table_break('', $INNERTABLEWIDTH);

	// ADMIN OVERRIDE OPTIONS SECTION
	print_table_header($vbphrase['admin_override_options']);
	foreach ($vbulletin->bf_misc_adminoptions AS $field => $value)
	{
		print_yes_no_row($vbphrase['keep_' . $field], 'adminoptions[' . $field . ']', $user["$field"]);
	}
	print_table_break('', $INNERTABLEWIDTH);

	// TIME FIELDS SECTION
	print_table_header($vbphrase['time_options']);
	print_select_row($vbphrase['timezone'], 'user[timezoneoffset]', fetch_timezones_array(), +3);
	print_yes_no_row($vbphrase['automatically_detect_dst_settings'], 'options[dstauto]', $user['dstauto']);
	print_yes_no_row($vbphrase['dst_currently_in_effect'], 'options[dstonoff]', $user['dstonoff']);
	print_select_row($vbphrase['default_view_age'], 'user[daysprune]', $pruneoptions, $user['daysprune']);
	print_time_row($vbphrase['join_date'], 'user[joindate]', $user['joindate']);
	print_time_row($vbphrase['last_activity'], 'user[lastactivity]', $user['lastactivity']);
	print_time_row($vbphrase['last_post'], 'user[lastpost]', $user['lastpost']);

	($hook = vBulletinHook::fetch_hook('useradmin_edit_column2')) ? eval($hook) : false;

	?>
	</table>
	</td>
	</tr>
	<?php

	print_table_break('', $OUTERTABLEWIDTH);
	$tableadded = 1;
	print_submit_row($vbphrase['save']);
}

// ###################### Start do update #######################
if ($_POST['do'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'userid'            => TYPE_UINT,
		'password'          => TYPE_STR,
		'user'              => TYPE_ARRAY,
		'options'           => TYPE_ARRAY_BOOL,
		'adminoptions'      => TYPE_ARRAY_BOOL,
		'userfield'         => TYPE_ARRAY,
		'modifyavatar'      => TYPE_NOCLEAN,
		'modifyprofilepic'  => TYPE_NOCLEAN,
		'modifysigpic'      => TYPE_NOCLEAN,
		'subscriptionlogid' => TYPE_ARRAY_KEYS_INT,
	));

	// check for 'undeletable' users
	$noalter = explode(',', $vbulletin->config['SpecialUsers']['undeletableusers']);
	if (!empty($noalter[0]) AND in_array($vbulletin->GPC['userid'], $noalter))
	{
		print_stop_message('user_is_protected_from_alteration_by_undeletableusers_var');
	}

	// init data manager
	$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_CP);
	$userdata->adminoverride = true;

	// set existing info if this is an update
	if ($vbulletin->GPC['userid'])
	{
		$userinfo = fetch_userinfo($vbulletin->GPC['userid']);
		$userinfo['posts'] = intval($vbulletin->GPC['user']['posts']);
		$userdata->set_existing($userinfo);
		if ($userdata->existing['userid'] != $vbulletin->GPC['userid'])
		{
			print_stop_message('invalid_user_specified');
		}
	}

	// password
	if (!empty($vbulletin->GPC['password']))
	{
		$userdata->set('password', $vbulletin->GPC['password']);
	}
	else if (!$vbulletin->GPC['userid'])
	{
		print_stop_message('invalid_password_specified');
	}

	// user options
	foreach ($vbulletin->GPC['options'] AS $key => $val)
	{
		$userdata->set_bitfield('options', $key, $val);
	}

	foreach($vbulletin->GPC['adminoptions'] AS $key => $val)
	{
		$userdata->set_bitfield('adminoptions', $key, $val);
	}

	$displaygroupid = ($vbulletin->GPC['user']['displaygroupid'] <= 0) ? $vbulletin->GPC['user']['usergroupid'] : $vbulletin->GPC['user']['displaygroupid'];
	// custom user title
	$userdata->set_usertitle(
		$vbulletin->GPC['user']['usertitle'],
		$vbulletin->GPC['user']['customtitle'] ? false : true,
		$vbulletin->usergroupcache["$displaygroupid"],
		true,
		$vbulletin->GPC['user']['customtitle'] == 1 ? true : false
	);
	unset($vbulletin->GPC['user']['usertitle'], $vbulletin->GPC['user']['customtitle']);

	// user fields
	foreach ($vbulletin->GPC['user'] AS $key => $val)
	{
		$userdata->set($key, $val);
	}

	if (empty($vbulletin->GPC['user']['membergroupids']))
	{
		$userdata->set('membergroupids', '');
	}

	// custom profile fields
	$userdata->set_userfields($vbulletin->GPC['userfield'], false, 'admin');

	($hook = vBulletinHook::fetch_hook('useradmin_update_save')) ? eval($hook) : false;

	// save data
	$userid = $userdata->save();
	if ($vbulletin->GPC['userid'])
	{
		$userid = $vbulletin->GPC['userid'];
	}

	// #############################################################################
	// now do the redirect

	if ($vbulletin->GPC['modifyavatar'])
	{
		define('CP_REDIRECT', "usertools.php?do=avatar&amp;u=$userid");
	}
	else if ($vbulletin->GPC['modifyprofilepic'])
	{
		define('CP_REDIRECT', "usertools.php?do=profilepic&amp;u=$userid");
	}
	else if ($vbulletin->GPC['modifysigpic'])
	{
		define('CP_REDIRECT', "usertools.php?do=sigpic&amp;u=$userid");
	}
	else if ($vbulletin->GPC['subscriptionlogid'])
	{
		define('CP_REDIRECT', "subscriptions.php?do=adjust&amp;subscriptionlogid=" . array_pop($vbulletin->GPC['subscriptionlogid']));
	}
	else
	{
		define('CP_REDIRECT', "user.php?do=modify&amp;u=$userid" . ($userdata->insertedadmin ? '&insertedadmin=1' : ''));
	}

	print_stop_message('saved_user_x_successfully', $user['username']);
}

print_cp_footer();

/*======================================================================*\
||     EDIT BY MGHOOL chat3hood@hotmail.com & iiio__oiii@hotmail.com 	||
\*======================================================================*/
?>
